function xprime=pointmass_derivatives(t,x)

global max  centx centy p1 p2 p12 p21 root wx ax cx wy ay cy h
global uxsave uysave tsave

xp=x(1);
yp=x(2);
eta=x(3);

J=max/(1+p1*(xp-centx)^2+p2*(yp-centy)^2)^(root);

vx=ax*wx*cos(wx*t)+cx*sin(wx*t)*(J-eta);
vy=ay*wy*sin(wy*t)-cy*cos(wx*t)*(J-eta);

xprime(1)=vx;
xprime(2)=vy;
xprime(3)=h*(J-eta);

xprime=xprime.';
tsave = [tsave;t];
uxsave = [uxsave;vx];
uysave = [uysave;vy];